//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T>
union un_01
{
    T value;
    uchar u8_bits[sizeof(T)];
};
//+------------------------------------------------------------------+
void OnStart(void)
{
//+----------------+
#define macro_Swap(X)   for (uchar i = 0, j = sizeof(X) - 1, tmp; i < j; i++, j--)  \
                        {                                                           \
                            tmp = X.u8_bits[i];                                     \
                            X.u8_bits[i] = X.u8_bits[j];                            \
                            X.u8_bits[j] = tmp;                                     \
                        }
//+----------------+

    {
        un_01 <ulong> info;

        info.value = 0xA1B2C3D4E5F6789A;
        PrintFormat("The region is composed of %d bytes", sizeof(info));
        PrintFormat("Before modification: 0x%I64X", info.value);
        macro_Swap(info);
        PrintFormat("After modification : 0x%I64X", info.value);
    }
    
    {
        un_01 <ushort> info;

        info.value = 0xCADA;
        PrintFormat("The region is composed of %d bytes", sizeof(info));
        PrintFormat("Before modification: 0x%I64X", info.value);
        macro_Swap(info);
        PrintFormat("After modification : 0x%I64X", info.value);
    }
}
//+------------------------------------------------------------------+